

# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")
library("reshape2")
library("psych")


# reshape2 using melt and cast examples

x1 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y1 <- c(8.04,6.95,7.58,8.81,8.33,9.96,7.24,4.26,10.84,4.82,5.68)
x2 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y2 <- c(9.14,8.14,8.74,8.77,9.26,8.10,6.13,3.10,9.13,7.26,4.74)
x3 <- c(10.0,8.0,13.0,9.0,11.0,14.0,6.0,4.0,12.0,7.0,5.0)
y3 <- c(7.46,6.77,12.74,7.11,7.81,8.84,6.08,5.39,8.15,6.42,5.73)
x4 <- c(8.0,8.0,8.0,8.0,8.0,8.0,8.0,19.0,8.0,8.0,8.0)
y4 <- c(6.58,5.76,7.71,8.84,8.47,7.04,5.25,12.50,5.56,7.91,6.89)

s1 <- c(1,1,1,1,1,1,1,1,1,1,1)
s2 <- c(2,2,2,2,2,2,2,2,2,2,2)
s3 <- c(3,3,3,3,3,3,3,3,3,3,3)
s4 <- c(4,4,4,4,4,4,4,4,4,4,4)

s1 <- cbind(s1,x1,y1)
s2 <- cbind(s2,x2,y2) 
s3 <- cbind(s3,x3,y3)
s4 <- cbind(s4,x4,y4)

anscombe <- data.frame(rbind(s1,s2,s3,s4))

anscombe_m <- anscombe
#anscombe_m <- melt(anscombe)
names(anscombe_m) <- c("set","x","y")

# Anscombe dataset
p1 <- ggplot(data=anscombe_m, aes(x=x1, y=y1)) +
  geom_point() +            # Use hollow circles
  geom_smooth(method=lm,    # Add linear regression line
              se=FALSE) +   # Don't add shaded confidence region
  ylim(2,13) + 
  xlim(3,20)
# save graph to file
ggsave(file="anscombe1.png")
ggsave(file="anscombe1.pdf")

p2 <- ggplot(data=anscombe_m, aes(x=x2, y=y2)) +
  geom_point() +           # Use hollow circles
  geom_smooth(method=lm,   # Add linear regression line
              se=FALSE) +  # Don't add shaded confidence region
  ylim(2,13) + 
  xlim(3,20)
# save graph to file
ggsave(file="anscombe2.png")
ggsave(file="anscombe2.pdf")

p3 <- ggplot(data=anscombe_m, aes(x=x3, y=y3)) +
  geom_point() +           # Use hollow circles
  geom_smooth(method=lm,   # Add linear regression line
              se=FALSE) +  # Don't add shaded confidence region
  ylim(2,13) + 
  xlim(3,20)
# save graph to file
ggsave(file="anscombe3.png")
ggsave(file="anscombe3.pdf")

p4 <- ggplot(data=anscombe_m, aes(x=x4, y=y4)) +
  geom_point() +           # Use hollow circles
  geom_smooth(method=lm,   # Add linear regression line
              se=FALSE) +  # Don't add shaded confidence region
  ylim(2,13) + 
  xlim(3,20)
# save graph to file
ggsave(file="anscombe4.png")
ggsave(file="anscombe4.pdf")

p <- ggplot(anscombe_m, aes(x=x, y=y)) + geom_point()
p <- p + geom_smooth(method = lm, se = FALSE) #+ annotate("text", label = "y=ax+b", x=5, y=11)
p <- p + facet_wrap(~set) + theme_gray() + ggtitle("Anscombe's quartet") #+ title("Anscombe's quartet")
#p <- p + annotate("text", label = "y = ax+b", x = 1, y = 12)
# save graph to file
ggsave(file="anscombe.png")
ggsave(file="anscombe.pdf")


# using the layer approach
pl <- ggplot(anscombe_m, aes(x=x1,y=y1)) +
  layer(
    #data=anscombe_m,
    #mapping=aes(x=x1,y=y1),
    #stat="identity",
    geom="point"#,
    #position=position_identity()
    ) + 
  layer(
    geom="smooth",
    method="lm",
    se=FALSE
    )
  
describeBy(x=anscombe_m, group=anscombe_m$set)


